/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.dialog.comp.TimeInputPanel;
import DE.siemens.ad.logo.dialog.comp.TimeUnitListCellRenderer;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public final class TimeOrReferenceSycnPanel
extends JPanel {
    private Timer fTimer;
    private TimeInputPanel fTimeParamPanel;
    private JLabel fLblTimeUnit;
    JToggleButton fReferenceButton = null;
    private JComboBox fReferenceList;
    private JComboBox fReferenceTimeUnitCombo;
    private JPanel fInputPanel;
    private CardLayout fInputManager;
    private transient String fTimeUnitKey = "dialog.timeParameter.seconds";

    public TimeOrReferenceSycnPanel() {
        this.initialize();
    }

    public TimeOrReferenceSycnPanel(Timer t) {
        this.fTimer = t;
        this.initialize();
    }

    private void referenceButtonPressed(boolean b) {
        this.setReference(this.fReferenceButton.isSelected());
    }

    private void setReference(boolean referenceEnabled) {
        if (referenceEnabled) {
            this.fInputManager.last(this.fInputPanel);
        } else {
            this.fInputManager.first(this.fInputPanel);
        }
        this.validate();
    }

    public void setReferenceAndButton(boolean referenceEnabled) {
        this.fReferenceButton.setSelected(referenceEnabled);
        this.setReference(referenceEnabled);
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        this.fInputManager = new CardLayout(1, 1);
        this.fInputPanel = new JPanel(this.fInputManager);
        this.add(this.fInputPanel);
        JPanel intPanel = new JPanel(new FlowLayout(0));
        this.fInputPanel.add((Component)intPanel, "Value");
        this.fTimeParamPanel = new TimeInputPanel();
        this.fLblTimeUnit = new JLabel("timeUnit");
        intPanel.add(this.fTimeParamPanel);
        intPanel.add(this.fLblTimeUnit);
        JPanel referencePanel = new JPanel(new FlowLayout(0));
        this.fInputPanel.add((Component)referencePanel, "reference");
        this.fReferenceList = new JComboBox();
        referencePanel.add(this.fReferenceList);
        BlockListCellRenderer renderer = new BlockListCellRenderer(true);
        renderer.setScale(0.7f);
        this.fReferenceList.setRenderer(renderer);
        this.fReferenceTimeUnitCombo = new JComboBox<TimeUnit>(this.getTimeUnitsForReference());
        this.fReferenceTimeUnitCombo.setRequestFocusEnabled(false);
        this.fReferenceTimeUnitCombo.setEnabled(false);
        this.fReferenceTimeUnitCombo.setRenderer(new TimeUnitListCellRenderer(false, "lowValue"));
        referencePanel.add(this.fReferenceTimeUnitCombo);
        this.fReferenceButton = new JToggleButton("Reference");
        this.fReferenceButton.addActionListener(new ReferenceButtonListener());
        this.add(this.fReferenceButton);
        this.setLabels();
    }

    protected TimeUnit[] getTimeUnitsForReference() {
        return new TimeUnit[]{new Hours(), new Minutes(), new HighResolutionSeconds()};
    }

    protected void setLabels() {
        this.fReferenceButton.setText(Language.getString("integerOrReferencePanel.referenceButtonText", "Reference"));
    }

    public boolean checkChanged() {
        TimeValueProperties oldValue = this.fTimer.getParamTimeProperties();
        if (oldValue.isReference() != this.fReferenceButton.isSelected()) {
            return true;
        }
        if (oldValue.isReference() && !this.equalItems(oldValue.getReference(), (ParameterItem)this.fReferenceList.getSelectedItem())) {
            return true;
        }
        return this.fTimeParamPanel.checkChanged(this.fTimer.getParamTime());
    }

    private void selectItemInReferenceList(ValueOrItemReference value) {
        ParameterItem item;
        int i;
        ParameterItem newItem = value.getReference();
        ComboBoxModel model = this.fReferenceList.getModel();
        int size = model.getSize();
        for (i = 0; i < size && !this.equalItems(item = (ParameterItem)model.getElementAt(i), newItem); ++i) {
        }
        this.fReferenceList.setSelectedIndex(i);
    }

    private boolean equalItems(ParameterItem item1, ParameterItem item2) {
        return item1.getParameterNumber() == item2.getParameterNumber() && item1.getParameter().getBlock().getNumber() == item2.getParameter().getBlock().getNumber();
    }

    public void setReferenceVisability(boolean visable) {
        this.fReferenceButton.setVisible(visable);
    }

    public JComboBox getReferenceList() {
        return this.fReferenceList;
    }

    public void setReferenceList(ArrayList paramItems) {
        this.fReferenceList.setModel(new DefaultComboBoxModel<Object>(paramItems.toArray()));
        this.fReferenceButton.setEnabled(paramItems.size() > 0);
    }

    public void setTimeUnit(TimeUnit t) {
        this.fTimeParamPanel.setHighValue(t.getHighValue());
        this.fTimeParamPanel.setLowValue(t.getLowValue());
        this.setTimeUnitKey(t);
    }

    public void setTimeUnitKey(TimeUnit value) {
        String timeUnitName = Language.getString(value.getUnitKey(), value.getDefaultUnitString());
        this.fLblTimeUnit.setText(timeUnitName);
        this.fTimeParamPanel.changeTimeUnit(value.getUnitKey());
        this.fTimeUnitKey = value.getUnitKey();
        ComboBoxModel model = this.fReferenceTimeUnitCombo.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            if (!((TimeUnit)model.getElementAt(i)).getUnitKey().equals(this.fTimeUnitKey)) continue;
            this.fReferenceTimeUnitCombo.setSelectedIndex(i);
        }
    }

    public boolean checkFieldContents() {
        if (this.fReferenceButton.isSelected()) {
            return true;
        }
        return this.fTimeParamPanel.checkFieldContents();
    }

    public void storeFieldContents() {
        if (this.fReferenceButton.isSelected()) {
            Reference newValue = new Reference();
            newValue.setTimeUnit(TimeUnit.getNewTimeObject(this.fTimeUnitKey));
            newValue.setReference((ParameterItem)this.fReferenceList.getSelectedItem());
            this.fTimer.setParamTime(newValue);
        } else {
            this.fTimer.setParamTime(0, 0, this.fTimeUnitKey);
            this.fTimeParamPanel.storeFieldContents(this.fTimer.getParamTime());
        }
    }

    public void loadFieldContents() {
        TimeValueProperties value = this.fTimer.getParamTimeProperties();
        boolean isReference = value.isReference();
        if (isReference) {
            this.selectItemInReferenceList(value);
            this.fReferenceButton.setSelected(true);
        } else {
            this.fTimeParamPanel.loadFieldContents(this.fTimer.getParamTime());
        }
        this.setTimeUnitKey(this.fTimer.getParamTime());
        this.setReference(isReference);
    }

    public void setEnabled(boolean enabled) {
        this.fInputPanel.setEnabled(enabled);
        this.fTimeParamPanel.setEnabled(enabled);
        this.fReferenceList.setEnabled(enabled);
        this.fReferenceButton.setEnabled(enabled && this.fReferenceList.getModel().getSize() > 0);
    }

    protected class ReferenceButtonListener
    implements ActionListener {
        protected ReferenceButtonListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            TimeOrReferenceSycnPanel.this.referenceButtonPressed(TimeOrReferenceSycnPanel.this.fReferenceButton.isSelected());
        }
    }
}

